# Dashboard zur Vertragsüberwachung

Das <span
style='font-weight:bold'>Dashboard zur Vertragsüberwachung</span> zeigt eine Übersicht aller abgelegten Verträge und gibt dem Sachbearbeiter gezielt die Möglichkeit, Vertragsfristen zu überwachen. Ebenso liefert es dem Management einen grundlegenden Überblick mit Hilfe von Kennzahlen und vielen Filtermöglichkeiten. 

Das Dashboard dient weiterhin als Einstieg zur Einsicht oder direkten Bearbeitung von hinterlegten Verträgen und bietet die Möglichkeit zum schnellen Wechsel zwischen diesen.

{@img img1.png}

## Kopfleiste

Das Dashboard ist mit einer allgegenwärtigen Kopfzeile ausgestattet, welche über die verschiedenen Ansichten hinweg stets sichtbar bleibt. Über die Kopfzeile können, neben der aktuellen Datenbasis, auch verschiedenen Ansichten auf die gewählten Daten angezeigt werden. Außerdem steht eine Freitextsuche zur Verfügung. Mit dieser können die angezeigten Daten weiter eingeschränkt werden.

{@img img3.png}

### Datenbasis

Die Datengrundlage für das Dashboard stellen so genannte <span
style='font-weight:bold;font-style:italic'>Dynamische Suchordner</span> dar. Weitere Informationen gibt <a
href="#!/guide/pFBEFA9E6_D1C9_43E2_9E89_934F035F4DA9">Datenbasis</a>.

<span class="tag_warning">Sollte das Dashboard direkt auf einer <a
href="#!/guide/p3639BF77_213A_477F_B14C_B1568C3E11E7">Vertragssammlung</a> im Archiv - also kontextbezogen - angewendet werden, fällt die Möglichkeit zum Wechsel zu anderen Sammlungen weg. Dies ist erkennbar am fehlenden Pfeil nach unten.</span>

<span class="tag_important">Die Datenbasis kann jederzeit auch manuell durch einen Klick auf das &quot;Aktualisieren&quot;-Symbol erneuert werden.</span>

### Wechsel zwischen den Ansichten

Während die Datenbasis im Hintergrund immer die Gleiche bleibt, können im Dashboard verschiedene Ansichten gewählt werden. Das Umschalten erfolgt über die Schaltflächen im rechten Bereich der Kopfleiste. 

{@img img5.png}

<span class="tag_important">Die Wahl der Ansicht wird clientseitig gespeichert. Bei einem erneuten Aufruf des Dashboards kann die Arbeit an gleicher Stelle fortgesetzt werden.</span>

### Freitextsuche

Zur weiteren Eingrenzung der angezeigten Daten kann die Freitextsuche verwendet werden. Sie reagiert bereits beim Eintippen und sorgt für eine automatische Aktualisierung der Ansichten. Neben reinen Textwerten können auch Termine und Beträge interpretiert werden.

{@img img7.png}

<span class="tag_important">Als Grundlage für diese Art der Filterung dienen alle Daten, die in der Tabellenansicht als Spaltenwerte ausgewählt werden können. Für eine noch tiefgreifendere Suche, nach im Dashboard nicht aufgeführten Werten in den Maskenfeldern, empfiehlt sich die allgemeine ELO-Suche.</span>

## Kennzahlen

Kennzahlen bieten einen schnellen statistischen Überblick, in welchem Bearbeitungszustand sich die im Dashboard hinterlegten Verträge befinden. Gleichzeitig bietet das Filtern dieser Kennzahlen die Möglichkeit, auf übersichtliche Weise die Daten einzuschränken.

Der Kennzahlenbereich kann über den Pfeil rechts außen in der Kopfleiste ein- und ausgeblendet werden. Im ausgeblendeten Zustand stehen dem Benutzer somit mehr Platz für die Inhalte zur Verfügung. 

### Statuswerte

Ein jedes Vertragsobjekt besitzt einen <a
href="#!/guide/p6A9FD817_883A_4DBE_ACE2_F7C172FD8BE8">Vertragsstatus</a>, der in der Verschlagwortungsmaske als `CONTRACT_STATUS` gespeichert wird. Die dazu gehörige lokalisierte Stichwortliste <span
style='font-weight:bold;font-style:italic'>status</span> dient als Basis für die möglichen Statuswerte im Dashboard. Jeder Eintrag dieser Liste wird als Filter-Schaltfläche angeboten, die gleichzeitig auch die Menge aller Verträge mit diesem Statuswert anzeigt. 

{@img img9.png}

Durch An- und Abwählen der verschiedenen Statuswerte kann die Datengrundlage des Dashboards verändert werden. 

> <span
style='font-style:italic'>Sollte sich ein Benutzer lediglich für Verträge vor dem Vertragsabschluss interessieren, so reicht ihm im Standard das Anwählen der Statuswerte </span><span
style='font-weight:bold;font-style:italic'>Entwurf</span><span
style='font-style:italic'>, </span><span style='font-weight:bold;font-style:
italic'>In Freigabe</span><span style='font-style:italic'>, </span><span
style='font-weight:bold;font-style:italic'>Freigegeben</span><span
style='font-style:italic'> und </span><span style='font-weight:bold;font-style:
italic'>In Verhandlung</span><span style='font-style:italic'> aus.</span>

<span class="tag_warning">Eine Erweiterung oder Anpassung der Einträge in der lokalisierten Stichwortliste hat automatisch Auswirkungen auf die Filter-Schaltflächen im Dashboard.</span>

<span class="tag_important">Die Wahl der Statuswerte wird clientseitig gespeichert. Bei einem erneuten Aufruf des Dashboards kann die Arbeit an gleicher Stelle fortgesetzt werden.</span>

### Vertragszustände

In Ergänzung zu den Statuswerten, die sich eher auf die Stationen im gesamten Prozess eines Vertrags beziehen, wird auch eine statistische Auswertung zu den verschiedenen Zuständen der abgeschlossenen Verträge geboten. Diese wird nur dann angezeigt, wenn in der gefilterten Datengrundlage auch abgeschlossene Verträge existieren.

{@img img11.png}

Als Grundlage für die Erhebung dieser Statistik dienen die hinterlegten Vertragsfristen. Dadurch ergeben sich folgende Zustände:

<table><thead><tr><td>Frist</td><td>Beschreibung</td></tr></thead><tbody><tr><td>Unterschrieben</td><td>Als unterschreiben gelten Verträge, deren Datum des Vertragsabschluss bereits gesetzt wurde und deren Vertragsstart sich aktuell in der Zukunft befindet.</td></tr><tr><td>Aktiv</td><td>Ein Vertrag ist aktiv, wenn er unterschrieben wurde und sich der Vertragsstart bereits stattgefunden hat.</td></tr><tr><td>In Prüfung</td><td>Aktive Verträge befinden sich automatisch in Prüfung, wenn sie zwischen Wiedervorlagedatum und Kündigungsfrist stehen.</td></tr><tr><td>Auslaufend</td><td>Ein Vertrag gilt als auslaufend, wenn seine Kündigungsfrist bereits überschritten wurde.</td></tr><tr><td>Abgelaufen</td><td>Ein abgeschlossener Vertrag gilt als abgelaufen, sobald das Vertragsende in der Vergangenheit liegt.</td></tr></tbody></table>

## Ansichten

Das Dashboard bietet verschiedene Ansichten auf eine zentrale Datengrundlage. Man könnte sie auch als den eigentlichen Arbeitsbereich eines Dashboards bezeichnen, während Kopfleiste und Kennzahlen lediglich für einen Überblick sorgen und zur übergreifenden Filterung der Daten beitragen. Die Ansichten sind für verschiedene Zwecke ausgerichtet. Im Detail werden sie in den Unterkapiteln zum Dashboard beschrieben.

<table><thead><tr><td>Ansicht</td><td>Beschreibung</td></tr></thead><tbody><tr><td><a
href="#!/guide/pAB2F21E3_8741_4B22_ACE0_C42E22EF732A">Tabelle</a></td><td>Tabellarische Auflistung der wichtigsten vertragsrelevanten Daten. Diese Ansicht bietet sich mit ihren Sortierungs- und Gruppierungsmöglichkeiten besonders für individuelle statistische Auswertungen an.</td></tr><tr><td><a
href="#!/guide/p04F33BAA_14AE_4F39_802E_C47D7D4F1DC2">Zeitleiste</a></td><td>Darstellung der Vertragszeiträumen auf einer Zeitleiste. In dieser Ansicht können Laufzeiten von Verträgen visuell veranschaulicht und miteinander verglichen werden.</td></tr><tr><td><a
href="#!/guide/pF159EE6B_DC4E_4B8B_A4A3_F2241D6EF7DF">Kalender</a></td><td>Anzeige von Vertragsfristen in Kalenderform. Diese Ansicht bietet einen terminlichen Überblick und kann ebenso als Einstieg für die tägliche Abarbeitung von Aufgaben genutzt werden.</td></tr></tbody></table>

## Responsive Design

Das Layout des Dashboards reagiert automatisch auf den zur Verfügung stehenden Platz. Klickt man im Client beispielsweise auf einen bestimmten Vertrag im Dashboard, so öffnet sich daneben die Dokumentenvorschau zum entsprechenden Vertragsobjekt. 

{@img img13.png}

Bei zu geringem horizontalem Platz werden Kennzahlen und Verträge nur noch getrennt angezeigt. Eine Auswahl dieser Bereiche kann über die Menü-Schaltfläche oben rechts erfolgen. Auch die Freitextsuche befindet sich in der schmalen Darstellung in diesem Menü.

{@img img15.png}




